<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Classroom;

class ModifyIndividualStudentsOptions extends \Google\Collection
{
  protected $collection_key = 'removeStudentIds';
  /**
   * IDs of students to be added as having access to this
   * coursework/announcement.
   *
   * @var string[]
   */
  public $addStudentIds;
  /**
   * IDs of students to be removed from having access to this
   * coursework/announcement.
   *
   * @var string[]
   */
  public $removeStudentIds;

  /**
   * IDs of students to be added as having access to this
   * coursework/announcement.
   *
   * @param string[] $addStudentIds
   */
  public function setAddStudentIds($addStudentIds)
  {
    $this->addStudentIds = $addStudentIds;
  }
  /**
   * @return string[]
   */
  public function getAddStudentIds()
  {
    return $this->addStudentIds;
  }
  /**
   * IDs of students to be removed from having access to this
   * coursework/announcement.
   *
   * @param string[] $removeStudentIds
   */
  public function setRemoveStudentIds($removeStudentIds)
  {
    $this->removeStudentIds = $removeStudentIds;
  }
  /**
   * @return string[]
   */
  public function getRemoveStudentIds()
  {
    return $this->removeStudentIds;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ModifyIndividualStudentsOptions::class, 'Google_Service_Classroom_ModifyIndividualStudentsOptions');
