<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Cloudchannel;

class GoogleCloudChannelV1CustomerEvent extends \Google\Model
{
  /**
   * Not used.
   */
  public const EVENT_TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * Primary domain for customer was changed.
   */
  public const EVENT_TYPE_PRIMARY_DOMAIN_CHANGED = 'PRIMARY_DOMAIN_CHANGED';
  /**
   * Primary domain of the customer has been verified.
   */
  public const EVENT_TYPE_PRIMARY_DOMAIN_VERIFIED = 'PRIMARY_DOMAIN_VERIFIED';
  /**
   * Resource name of the customer. Format:
   * accounts/{account_id}/customers/{customer_id}
   *
   * @var string
   */
  public $customer;
  /**
   * Type of event which happened for the customer.
   *
   * @var string
   */
  public $eventType;

  /**
   * Resource name of the customer. Format:
   * accounts/{account_id}/customers/{customer_id}
   *
   * @param string $customer
   */
  public function setCustomer($customer)
  {
    $this->customer = $customer;
  }
  /**
   * @return string
   */
  public function getCustomer()
  {
    return $this->customer;
  }
  /**
   * Type of event which happened for the customer.
   *
   * Accepted values: TYPE_UNSPECIFIED, PRIMARY_DOMAIN_CHANGED,
   * PRIMARY_DOMAIN_VERIFIED
   *
   * @param self::EVENT_TYPE_* $eventType
   */
  public function setEventType($eventType)
  {
    $this->eventType = $eventType;
  }
  /**
   * @return self::EVENT_TYPE_*
   */
  public function getEventType()
  {
    return $this->eventType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudChannelV1CustomerEvent::class, 'Google_Service_Cloudchannel_GoogleCloudChannelV1CustomerEvent');
