<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\OnDemandScanning;

class AnalyzePackagesRequestV1 extends \Google\Collection
{
  protected $collection_key = 'packages';
  /**
   * [DEPRECATED] Whether to include OSV data in the scan. For backwards
   * compatibility reasons, this field can be neither removed nor renamed.
   *
   * @deprecated
   * @var bool
   */
  public $includeOsvData;
  protected $packagesType = PackageData::class;
  protected $packagesDataType = 'array';
  /**
   * Required. The resource URI of the container image being scanned.
   *
   * @var string
   */
  public $resourceUri;

  /**
   * [DEPRECATED] Whether to include OSV data in the scan. For backwards
   * compatibility reasons, this field can be neither removed nor renamed.
   *
   * @deprecated
   * @param bool $includeOsvData
   */
  public function setIncludeOsvData($includeOsvData)
  {
    $this->includeOsvData = $includeOsvData;
  }
  /**
   * @deprecated
   * @return bool
   */
  public function getIncludeOsvData()
  {
    return $this->includeOsvData;
  }
  /**
   * The packages to analyze.
   *
   * @param PackageData[] $packages
   */
  public function setPackages($packages)
  {
    $this->packages = $packages;
  }
  /**
   * @return PackageData[]
   */
  public function getPackages()
  {
    return $this->packages;
  }
  /**
   * Required. The resource URI of the container image being scanned.
   *
   * @param string $resourceUri
   */
  public function setResourceUri($resourceUri)
  {
    $this->resourceUri = $resourceUri;
  }
  /**
   * @return string
   */
  public function getResourceUri()
  {
    return $this->resourceUri;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AnalyzePackagesRequestV1::class, 'Google_Service_OnDemandScanning_AnalyzePackagesRequestV1');
